<?php
$countries = array();
foreach ($link_countries as $link_country) {
    $country[ 'name' ] = $link_country[ 'Stat' ][ 'country' ];
    $country[ 'num' ]  = $link_country[ '0' ][ 'country_num' ];
    $countries[]       = $country;
}

$referrers = array();
foreach ($link_referrers as $link_referrer) {
    $referrer[ 'domain' ] = $link_referrer[ 'Stat' ][ 'referer_domain' ];
    $referrer[ 'num' ]    = $link_referrer[ '0' ][ 'num' ];
    $referrers[]          = $referrer;
}

$browsers = array();
foreach ($link_browsers as $link_browser) {
    $browser[ 'browser' ] = $link_browser[ 'Stat' ][ 'browser' ];
    $browser[ 'num' ]     = $link_browser[ '0' ][ 'browser_num' ];
    $browsers[]           = $browser;
}

$platforms = array();
foreach ($link_platforms as $link_platform) {
    $platform[ 'platform' ] = $link_platform[ 'Stat' ][ 'platform' ];
    $platform[ 'num' ]      = $link_platform[ '0' ][ 'platform_num' ];
    $platforms[]            = $platform;
}
?>

<div class="container">

    <h3 class="page-title">Stats</h3>

    <div class="box">
        <div class="box-body">
            <div class="row">
                <div class="col-sm-3 text-center">
                    <img src="//api.webthumbnail.org/?width=400&height=300&screen=1366&url=<?php echo urlencode($link[ 'Link' ][ 'long_url' ]); ?>" alt="<?php echo h($link[ 'Link' ][ 'title' ]); ?>" title="<?php echo h($link[ 'Link' ][ 'title' ]); ?>">
                </div>
                <div class="col-sm-7">
                    <h3 class="page-header title"><?php echo $this->MightyLink->favicon($link[ 'Link' ][ 'long_url' ]); ?> <?php echo $this->Html->link($link[ 'Link' ][ 'title' ], $link[ 'Link' ][ 'long_url' ]); ?></h3>
                    <p><small><?php echo $this->Text->autoLinkUrls($link[ 'Link' ][ 'long_url' ], array( 'class' => 'text-muted' )); ?></small></p>
                    <p><?php echo h($link[ 'Link' ][ 'description' ]); ?></p>
                </div>
                <div class="col-sm-2 text-center">
                    <img alt="QR code" src="//chart.googleapis.com/chart?cht=qr&amp;chs=150x150&amp;choe=UTF-8&amp;chld=H|0&amp;chl=<?php echo urlencode($this->Html->url('/' . $link[ 'Link' ][ 'alias' ], true)); ?>">
                </div>
            </div>
        </div>
    </div>

    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-sm-12">

            <!-- Info box -->
            <div class="box box-info wow fadeInUp">
                <div class="box-header">
                    <i class="glyphicon glyphicon-stats"></i> <h3 class="box-title">Clicks on last 30 days</h3>
                </div>
                <div class="box-body">
                    <div class="chart" id="last-month-hits" style="position: relative; height: 300px; width: 100%;"></div>
                </div><!-- /.box-body -->
            </div><!-- /.box -->

            <hr>

            <?php if (in_array($user_plan[ 'Plan' ][ 'stats' ], array( 1, 2 ))) : ?>

                <div class="box box-success wow fadeInUp">
                    <div class="box-header">
                        <h3 class="box-title">Countries</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-8">
                                <div id="countries_geochart" style="position: relative; height: 300px; width: 100%;"></div>
                            </div>
                            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($countries as $country) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $country[ 'name' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $country[ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($country);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
            <?php endif; ?>

            <?php if (in_array($user_plan[ 'Plan' ][ 'stats' ], array( 2 ))) : ?>
                <div class="row wow fadeInUp">
                    <div class="col-sm-4">
                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title">Continents</h3>
                            </div>
                            <div class="box-body" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_continents as $link_continent) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_continent[ 'Stat' ][ 'continent' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_continent[ 0 ][ 'continent_num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_continent);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title">States</h3>
                            </div>
                            <div class="box-body" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_states as $link_state) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_state[ 'Stat' ][ 'state' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_state[ 0 ][ 'state_num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_state);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title">Cities</h3>
                            </div>
                            <div class="box-body" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_cities as $link_city) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_city[ 'Stat' ][ 'city' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_city[ 0 ][ 'city_num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_city);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="box box-info wow fadeInUp">
                    <div class="box-header">
                        <i class="fa fa-share-square-o"></i> <h3 class="box-title">Social Media Counts</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-2 text-center">
                                <span class="display-counter"><?php echo $facebook_count; ?></span>
                                <i class="fa fa-facebook-square fa-3x" style="color: #3b5998;"></i>
                            </div>
                            <div class="col-sm-2 text-center">
                                <span class="display-counter"><?php echo $google_plus_count; ?></span>
                                <i class="fa fa-google-plus-square fa-3x" style="color: #dd4b39;"></i>
                            </div>
                            <div class="col-sm-2 text-center">
                                <span class="display-counter"><?php echo $pinterest_count; ?></span>
                                <i class="fa fa-pinterest-square fa-3x" style="color: #cb2027;"></i>
                            </div>
                            <div class="col-sm-2 text-center">
                                <span class="display-counter"><?php echo $linkedin_count; ?></span>
                                <i class="fa fa-linkedin-square fa-3x" style="color: #007bb6;"></i>
                            </div>
                            <div class="col-sm-2 text-center">
                                <span class="display-counter"><?php echo $stumbledupon_count; ?></span>
                                <i class="fa fa-stumbleupon-circle fa-3x" style="color: #EB4823;"></i>
                            </div>
                            <div class="col-sm-2 text-center">
                                <span class="display-counter"><?php echo $reddit_count; ?></span>
                                <i class="fa fa-reddit-square fa-3x" style="color: #333333;"></i>
                            </div>
                        </div>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->

                <hr>

                <div class="box box-success wow fadeInUp">
                    <div class="box-header">
                        <h3 class="box-title">Referrers</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-8">
                                <div id="referrers_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                            </div>
                            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Domain</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($referrers as $referrer) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $referrer[ 'domain' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $referrer[ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($referrer);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="box box-success wow fadeInUp">
                    <div class="box-header">
                        <h3 class="box-title">Browsers</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-8">
                                <div id="browsers_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                            </div>
                            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($browsers as $browser) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $browser[ 'browser' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $browser[ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($browser);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="box box-success wow fadeInUp">
                    <div class="box-header">
                        <h3 class="box-title">Platforms</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-8">
                                <div id="platforms_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                            </div>
                            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($platforms as $platform) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $platform[ 'platform' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $platform[ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($platform);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="box box-success wow fadeInUp">
                    <div class="box-header">
                        <h3 class="box-title">Languages</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-8">
                                <div id="languages_barchart" style="position: relative; height: 300px; width: 100%;"></div>
                            </div>
                            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_languages as $link_language) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_language[ 'Stat' ][ 'language' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_language[ 0 ][ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_language);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="box box-success wow fadeInUp">
                    <div class="box-header">
                        <h3 class="box-title">Devices</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-8">
                                <div id="devices_donut" style="position: relative; height: 300px; width: 100%;"></div>
                            </div>
                            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Domain</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_devices as $link_device) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_device[ 'Stat' ][ 'device_type' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_device[ 0 ][ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_device);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <div class="col-sm-6 wow fadeInUp">
                        <div class="box box-success">
                            <div class="box-header">
                                <h3 class="box-title">Mobile Device Brands</h3>
                            </div>
                            <div class="box-body" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_brands as $link_brand) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_brand[ 'Stat' ][ 'device_brand' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_brand[ 0 ][ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_brand);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 wow fadeInUp">
                        <div class="box box-success">
                            <div class="box-header">
                                <h3 class="box-title">Mobile Device Names</h3>
                            </div>
                            <div class="box-body" style="height: 300px;overflow: auto;">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Clicks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($link_device_names as $link_device_name) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo $link_device_name[ 'Stat' ][ 'device_name' ];
                                            echo '</td>';
                                            echo '<td>';
                                            echo $link_device_name[ 0 ][ 'num' ];
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                        unset($link_device_name);
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endif; ?>

        </div>
    </div>
    <!-- END PAGE CONTENT-->


</div>

<?php $this->start('scriptBottom'); ?>

<style>
    .morris-hover{position:absolute;z-index:1090;}.morris-hover.morris-default-style{border-radius:10px;padding:6px;color:#f9f9f9;background:rgba(0, 0, 0, 0.8);border:solid 2px rgba(0, 0, 0, 0.9);font-weight: 600;font-size:14px;text-align:center;}.morris-hover.morris-default-style .morris-hover-row-label{font-weight:bold;margin:0.25em 0;}
    .morris-hover.morris-default-style .morris-hover-point{white-space:nowrap;margin:0.1em 0;}

</style>

<!-- Morris.js charts -->
<script src="<?php echo $this->Html->url('/'); ?>assets/lib/raphael/raphael-min.js"></script>
<script src="<?php echo $this->Html->url('/'); ?>backend/js/plugins/morris/morris.min.js" type="text/javascript"></script>

<script>

    jQuery( document ).ready( function () {
        new Morris.Bar( {
            element: 'last-month-hits',
            resize: true,
            data: [
<?php
$last30days = array();
for ($i = 30; $i > 0; $i--) {
    $last30days[ date('d-m-Y', strtotime('-' . $i . ' days')) ] = 0;
}
foreach ($linksStats as $linksStat) {
    if (empty($linksStat[ 0 ][ "statDateCount" ])) {
        $linksStat[ 0 ][ "statDateCount" ] = 0;
    }
    $last30days[ $linksStat[ 0 ][ "statDate" ] ] = $linksStat[ 0 ][ "statDateCount" ];
}

foreach ($last30days as $key => $value) {
    $date = date("Y-m-d", strtotime($key));
    echo '{date: "' . $date . '", clicks: ' . $value . '},';
}
?>
            ],
            xkey: 'date',
            xLabels: 'day',
            ykeys: [ 'clicks' ],
            labels: [ 'Clicks' ],
            lineWidth: 2,
            hideHover: 'auto',
            smooth: false
        } );

<?php if (in_array($user_plan[ 'Plan' ][ 'stats' ], array( 2 ))) : ?>
            /**
             * Browsers
             */


            new Morris.Bar( {
                element: 'browsers_barchart',
                resize: true,
                data: [
    <?php
    foreach ($browsers as $browser) {
        echo '{browser: "' . $browser[ "browser" ] . '", clicks: ' . $browser[ "num" ] . '},';
    }
    unset($browser);
    ?>
                ],
                xkey: 'browser',
                xLabels: 'Browser',
                ykeys: [ 'clicks' ],
                labels: [ 'Clicks' ],
                lineWidth: 2,
                hideHover: 'auto',
                smooth: false
            } );


            /**
             * Platforms
             */


            new Morris.Bar( {
                element: 'platforms_barchart',
                resize: true,
                data: [
    <?php
    foreach ($platforms as $platform) {
        echo '{platform: "' . $platform[ "platform" ] . '", clicks: ' . $platform[ "num" ] . '},';
    }
    unset($platform);
    ?>
                ],
                xkey: 'platform',
                xLabels: 'Platform',
                ykeys: [ 'clicks' ],
                labels: [ 'Clicks' ],
                lineWidth: 2,
                hideHover: 'auto',
                smooth: false
            } );


            /**
             * Referrers
             */

            new Morris.Bar( {
                element: 'referrers_barchart',
                resize: true,
                data: [
    <?php
    foreach ($referrers as $referrer) {
        echo '{referrer: "' . $referrer[ "domain" ] . '", clicks: ' . $referrer[ "num" ] . '},';
    }
    unset($platform);
    ?>
                ],
                xkey: 'referrer',
                xLabels: 'Referrer',
                ykeys: [ 'clicks' ],
                labels: [ 'Clicks' ],
                lineWidth: 2,
                hideHover: 'auto',
                smooth: false
            } );

            /**
             * Languages
             */

            new Morris.Bar( {
                element: 'languages_barchart',
                resize: true,
                data: [
    <?php
    foreach ($link_languages as $link_language) {
        echo '{language: "' . $link_language[ "Stat" ][ "language" ] . '", clicks: ' . $link_language[ 0 ][ "num" ] . '},';
    }
    unset($link_language);
    ?>
                ],
                xkey: 'language',
                xLabels: 'Language',
                ykeys: [ 'clicks' ],
                labels: [ 'Clicks' ],
                lineWidth: 2,
                hideHover: 'auto',
                smooth: false
            } );

            /**
             * devices Type
             */

            new Morris.Donut( {
                element: 'devices_donut',
                resize: true,
                data: [
    <?php
    foreach ($link_devices as $link_device) {
        echo '{label: "' . $link_device[ 'Stat' ][ "device_type" ] . '", value: ' . $link_device[ 0 ][ "num" ] . '},';
    }
    unset($link_device);
    ?>
                ],
                smooth: false
            } );
<?php endif; ?>

    } );



</script>

<?php if (in_array($user_plan[ 'Plan' ][ 'stats' ], array( 1, 2 ))) : ?>
    <script type="text/javascript" src="https://www.google.com/jsapi"></script>

    <script type='text/javascript'>
    google.load( 'visualization', '1', { 'packages': [ 'geochart' ] } );
    google.setOnLoadCallback( drawRegionsMap );

    function drawRegionsMap() {
        var data = google.visualization.arrayToDataTable( [
            [ 'Country', 'Clicks' ],
    <?php
    foreach ($countries as $country) {
        echo '["' . $country[ "name" ] . '", ' . $country[ "num" ] . '],';
    }
    ?>
        ] );

        var options = { };

        var chart = new google.visualization.GeoChart( document.getElementById( 'countries_geochart' ) );
        chart.draw( data, options );
    }
    ;
    </script>
<?php endif; ?>

<?php $this->end(); ?>
